#include<stdio.h>
#include<fcntl.h>
#include<linux/cdrom.h>
#include<sys/ioctl.h>
#include<errno.h>
#include"crypt.h"

static int fd;
static int agid;
static int debug = 1;

int ResetAGID(int fd)
{
	dvd_authinfo ai;
	int i;

	for (i =0; i < 4; i++) {
		memset(&ai, 0, sizeof(ai));
		ai.type = DVD_INVALIDATE_AGID;
		ai.lsasf.agid = i;
		ioctl(fd, DVD_AUTH, &ai);
	}
}

int GetDiscKey(int fd, int agid, char *key)
{
	dvd_struct s;

	s.type = DVD_STRUCT_DISCKEY;
	s.disckey.agid = agid;
	if (ioctl(fd, DVD_READ_STRUCT, &s)<0)
	{
		printf("Could not read Disc Key\n");
		return -1;
	}
	return 0;
}

int main(void)
{
	int index;
	int drive_index;
	int cpm, cgms;
	dvd_authinfo ai;
	
	unsigned char Challenge[10];
	unsigned char Key1[5];
	unsigned char Key2[5];
	unsigned char KeyCheck[5];
	unsigned char DiscKey[10];
	
	fd = open("/dev/hdc", O_RDONLY);
	if (fd >= 0)
	{
		printf("Open success\n"); 

		ResetAGID(fd);	
		memset((void *)&ai, 0, sizeof(ai));
		ai.type = DVD_LU_SEND_AGID;
		if (ioctl(fd, DVD_AUTH, &ai)<0)
		{
			printf("DVD_AUTH failed\n");	
			close(fd);
			return 0;
		}
		agid = ai.lsa.agid;
		printf("Received agid %d\n", agid);

		ai.type = DVD_HOST_SEND_CHALLENGE;
		srand(time(NULL));

		printf("Sending Challenge:\t");
		for (index=0; index<10; index++)
		{
			ai.hsc.chal[9-index] = rand()&0xFF;
			printf("%02X ", ai.hsc.chal[9-index]);
			Challenge[index] = ai.hsc.chal[9-index];
		}
		printf("\n");
		
		if (ioctl(fd, DVD_AUTH, &ai) < 0)
		{
			printf("Failed to send Challenge to LU\n");
			close(fd);
			return 0;
		}
	
		if (ioctl(fd, DVD_AUTH, &ai) < 0)
		{
			printf("Could not get Key1\n");
			close(fd);
			return 0;
		}

		printf("Received Key1:\t\t");
		for (index=0; index<5; index++)
		{
			printf("%02X ", ai.lsk.key1[4-index]);
			Key1[index] = ai.lsk.key1[4-index];
		}
		printf("\n");

		for (drive_index = -1, index=31; index >=0; index--)
		{
			int i;
	
			CryptKey1(index, Challenge, KeyCheck);
			if (memcmp(KeyCheck, Key1, 5)==0)
			{
				drive_index = index;
				printf("Drive Authentic\n");
				break;
			}
		}

		if (drive_index == -1)
		{
			printf("Drive would not Authenticate\n");
			close(fd);
			return 0;
		}

		ai.type = DVD_LU_SEND_CHALLENGE;
		if (ioctl(fd, DVD_AUTH, &ai)<0)
		{
			printf("LU would not send challenge\n");
			close(fd);
			return 0;
		}

		printf("Received Challenge:\t");
		for (index = 0; index < 10; index++)
		{
			printf("%02X ", ai.lsc.chal[9-index]);
			Challenge[index] = ai.lsc.chal[9-index];
		}
		printf("\n");

		CryptKey2(drive_index, Challenge, Key2);
		ai.type = DVD_HOST_SEND_KEY2;
		printf("Sending Key2:\t\t");
		for (index = 0; index < 5; index++)
		{
			printf("%02X ", Key2[index]);
			ai.hsk.key2[4-index] = Key2[index];
		}
		printf("\n");
		if (ioctl(fd, DVD_AUTH, &ai)<0)
		{
			printf("LU did not accept Key2\n");
			close(fd);
			return 0;
		}
		printf("Host is Authentic\n");
		memcpy(Challenge, Key1, 5);
		memcpy(Challenge+5, Key2, 5);
		CryptBusKey(index, Challenge, KeyCheck);
		GetDiscKey(fd, ai.lsa.agid, KeyCheck);

		close(fd);
	}
	return 0;
}
