# $Id: 50_session.t,v 1.1 2001/07/06 05:05:10 fil Exp $
use strict;
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..6\n"; }
use JAAS::Config;
use JAAS::Config::Session;

# sub POE::Kernel::TRACE_EVENTS () {1}

use Data::Dumper;
use POE::Kernel;
use POE::Session;

my $loaded = 1;
END {print "not ok 1\n" unless $loaded;}
print "ok 1\n";

#####################################################
JAAS::Config::Session->spawn();
MyPackage->spawn();

$poe_kernel->run();

#####################################################
package MyPackage;
use strict;
use POE::Session;

my $FILE;
BEGIN {$FILE="t/test3.conf"};

sub spawn
{
    $_[0]||=__PACKAGE__;
    POE::Session->create(package_states=>
            [$_[0], [qw(_start one two_cb get42 loaded fourtytwo1 
                                fourtytwo2 _stop)]]
        );
}

sub _start
{
    print "ok 2\n";
    $_[KERNEL]->post(JAAS_Config=>'load', $FILE);
    $_[KERNEL]->delay(one=>1);
    $_[KERNEL]->alias_set('pester');
}

sub _stop
{
    if(-e "$FILE.delta") {
        unlink "$FILE.delta" or warn "$FILE.delta: $!";
    }
}

sub one
{
    my $one=$_[KERNEL]->call(JAAS_Config=>'get', [qw(something one)]);
    print $one==1 ? '' : 'not ';
    print "ok 3\n";
    $_[KERNEL]->post(JAAS_Config=>'get_pb', [qw(something two)], 'two_cb');
}

sub two_cb
{
    my $two=$_[ARG0];
    
    print $two==2 ? '' : 'not ';
    print "ok 4\n";

    $_[KERNEL]->post(JAAS_Config=>'set', [qw(something fourtytwo 42)]);
    $_[KERNEL]->yield('get42');
}

sub get42
{
    $_[KERNEL]->post(JAAS_Config=>'get_pb', [qw(something fourtytwo)], 
                                        'fourtytwo1');
}

sub fourtytwo1
{
    my $_42=$_[ARG0];
    
    print $_42==42 ? '' : 'not ';
    print "ok 5\n";

    $_[KERNEL]->post(JAAS_Config=>'save');
    $_[KERNEL]->post(JAAS_Config=>'load', $FILE);

    $_[KERNEL]->yield('loaded');
}

sub loaded
{
    $_[KERNEL]->post(JAAS_Config=>'get_pb', [qw(something fourtytwo)], 
                                        'fourtytwo2');
    
}


sub fourtytwo2
{
    my $_42=$_[ARG0];
    
    print $_42==42 ? '' : 'not ';
    print "ok 6\n";
    
}